
from asyncio import sleep
import sys,tty,os,termios
# fleming.hta.keypress_functions.getkey

def getkey():
    old_settings = termios.tcgetattr(sys.stdin)
    tty.setcbreak(sys.stdin.fileno())
    try:
        while True:
            b = os.read(sys.stdin.fileno(), 3).decode()
            if len(b) == 3:
                k = ord(b[2])
            else:
                k = ord(b)
            key_mapping = {
                127: 'backspace',
                10: 'return',
                32: 'space',
                9: 'tab',
                27: 'esc',
                65: 'up',
                66: 'down',
                67: 'right',
                68: 'left'
            }
            return key_mapping.get(k, chr(k))
    finally:
        termios.tcsetattr(sys.stdin, termios.TCSADRAIN, old_settings)



import sys
import termios
import contextlib
from fleming.hta.static_functions import static_counter

@contextlib.contextmanager
def raw_mode(file):
    
    old_attrs = termios.tcgetattr(file.fileno())
    new_attrs = old_attrs[:]
    new_attrs[3] = new_attrs[3] & ~(termios.ECHO | termios.ICANON)
    try:
        termios.tcsetattr(file.fileno(), termios.TCSADRAIN, new_attrs)
        yield
    finally:
        termios.tcsetattr(file.fileno(), termios.TCSADRAIN, old_attrs)

import sys
import subprocess
# fleming.hta.keypress_functions.testing
def testing():
    subprocess.check_call([sys.executable, '-m', 'pip', 'install', 'keyboard'])
    print('exit with ^C or ^D')
    with raw_mode(sys.stdin):
        try:
            while True:
                print(f"counter, {static_counter()}")
                ch = sys.stdin.read(1)
                if not ch or ch == chr(4):
                    break
                print('%02x' % ord(ch))
        except (KeyboardInterrupt, EOFError):
            pass



# if GlobalVar.get_stop_gc():
#     await send_to_gc("Script stopped by user")
#     return
